/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.mapui;

import filenet.sim.toolkit.viewer.VWSIMAnimatorRoute;
import filenet.sim.toolkit.viewer.mapui.images.VWSIMImageLoader;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWImageAttrUI;
import filenet.vw.toolkit.utils.mapui.VWLabelUI;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.ImageIcon;

public class VWSIMAnimatorRouteUI
extends VWBaseRouteUI {
    private VWSIMAnimatorRoute m_route = null;
    protected static Image s_workItemImage = null;
    protected static int s_workItemImageWidth = 0;
    protected static int s_workItemImageHeight = 0;
    private static final int WORKITEM_LOC_COUNT = 6;
    private VWLabelUI m_workItemIcon = new VWLabelUI();
    private boolean m_bMoveWorkItem = false;
    private int m_curWorkItemIconLocation = 0;

    public VWSIMAnimatorRouteUI(VWSIMAnimatorRoute route, VWBaseStepUI srcStep, VWBaseStepUI destStep, boolean bfocus, int lineType, VWStepRouteColors stepRouteColors, VWMapAttribs mapAttribs) {
        super(route.getRouteDefinition(), srcStep, destStep, bfocus, lineType, stepRouteColors, mapAttribs);
        ImageIcon imageIcon;
        this.m_route = route;
        if (s_workItemImage == null && (imageIcon = VWSIMImageLoader.createImageIcon("animate_route.gif")) != null) {
            s_workItemImageWidth = imageIcon.getIconWidth();
            s_workItemImageHeight = imageIcon.getIconHeight();
            s_workItemImage = imageIcon.getImage();
        }
    }

    public VWSIMAnimatorRouteUI(VWRouteDefinition routeDefinition, VWBaseStepUI srcStep, VWBaseStepUI destStep, boolean bfocus, int lineType, VWStepRouteColors stepRouteColors, VWMapAttribs mapAttribs) {
        super(routeDefinition, srcStep, destStep, bfocus, lineType, stepRouteColors, mapAttribs);
    }

    public VWSIMAnimatorRoute getRouteData() {
        return this.m_route;
    }

    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_bMoveWorkItem && this.m_curWorkItemIconLocation <= 6) {
            Point pt = this.m_render.getPoint(this.m_curWorkItemIconLocation * 100 / 6);
            ++this.m_curWorkItemIconLocation;
            if (this.m_curWorkItemIconLocation > 6) {
                this.moveWorkItem(false);
            }
            if (pt != null) {
                this.m_workItemIcon.paintComponent(g, pt, true);
            }
        }
    }

    public int getId() {
        return this.m_route.getRouteId();
    }

    public String getName() {
        return this.m_route.getRouteName();
    }

    public void moveWorkItem(boolean bMove) {
        this.m_bMoveWorkItem = bMove;
        this.m_curWorkItemIconLocation = 0;
        this.m_workItemIcon.removeAllAttributes();
        if (bMove) {
            this.m_workItemIcon.addAttribute(new VWImageAttrUI(s_workItemImage));
        }
    }

    public boolean isMovingWorkItem() {
        return this.m_bMoveWorkItem;
    }

    public void moveWorkIcon() {
        if (this.m_curWorkItemIconLocation <= 6) {
            Point pt = null;
            Rectangle prevRect = null;
            Rectangle rect = null;
            int prevLoc = this.m_curWorkItemIconLocation - 1;
            int w = (s_workItemImageWidth + 1) / 2;
            int h = (s_workItemImageHeight + 1) / 2;
            if (prevLoc >= 0) {
                pt = this.m_render.getPoint(prevLoc * 100 / 6);
                prevRect = new Rectangle(pt.x - w, pt.y - h, w * 2, h * 2);
            }
            pt = this.m_render.getPoint(this.m_curWorkItemIconLocation * 100 / 6);
            rect = new Rectangle(pt.x - w, pt.y - h, w * 2, h * 2);
            if (prevRect != null) {
                rect = rect.union(prevRect);
            }
            this.repaint(rect);
        }
    }

    public static int getMoveCount() {
        return 6;
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_workItemIcon = null;
        this.m_route = null;
    }

    public Rectangle getBounds() {
        Rectangle rect = super.getBounds();
        Rectangle r = null;
        Point pt = null;
        int w = (s_workItemImageWidth + 1) / 2;
        int h = (s_workItemImageHeight + 1) / 2;
        for (int i = 0; i <= 6; ++i) {
            pt = this.m_render.getPoint(i * 100 / 6);
            r = new Rectangle(pt.x - w, pt.y - h, w * 2, h * 2);
            rect = rect.union(r);
        }
        return rect;
    }
}

